// ==UserScript==
// @name         Canvas Components
// @namespace    http://tampermonkey.net/
// @version      2025-03-16
// @description  Insert various components on a Canvas page
// @author       Espen Raugstad
// @match        https://uia.instructure.com/courses/*/pages/*/edit
// @icon         https://www.google.com/s2/favicons?sz=64&domain=instructure.com
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    // Components
    const literature_box = `<div
      style="
        display: flex;
        flex-direction: column;
        position: relative;
        padding: 2.5rem 1.25rem 1.5rem 1.25rem;
        border: 2px solid black;
        border-radius: 1rem;
        margin: 3rem 0.5rem 1.5rem 0.5rem;
        background-color: transparent;
      "
    >
      <div
        style="
          position: absolute;
          margin: 0;
          border-radius: 9999px;
          width: 4rem;
          height: 4rem;
          max-width: 100px;
          top: -32px;
          left: 2rem;
          background-color: white;
        "
      >
        <img
          style="
            margin: 0;
            padding: 0;
            border-radius: 9999px;
            height: 4rem;
            width: 4rem;
          "
          role="presentation"
          src="https://uia.instructure.com/files/2628672/download?download_frd=1&verifier=LY4OHhKUGwk94k5rjNwPjZ5VR7KVjmgGHB2Obywr"
          alt=""
        />
      </div>
      <div
        style="
          display: flex;
          align-items: center;
          padding: 0;
          margin: 0 0 0.5rem 0;
        "
      >
        <h3
          style="border: 0; margin: 0; padding: 0; color: black"
        >
          Litteratur
        </h3>
      </div>
      <div
        style="
          display: inline-block;
          padding: 0.25rem 0.5rem;
          border-radius: 0.25rem;
          font-size: 0.75rem;
          line-height: 1rem;
          letter-spacing: 0.1em;
          margin-bottom: 0.25rem;
          width: 10rem;
          background-color: #f8eddd;
          color: black;
        "
      >
        <strong>UTVALGT</strong>
      </div>
      <div style="margin: 0; padding: 0">
        <ul>
          <li>Tittel/tekst</li>
        </ul>
      </div>
      <div
        style="
          display: inline-block;
          padding: 0.25rem 0.5rem;
          border-radius: 0.25rem;
          font-size: 0.75rem;
          line-height: 1rem;
          letter-spacing: 0.1em;
          margin-bottom: 0.25rem;
          margin-top: 0.5rem;
          width: 10rem;
          background-color: #e6f0e5;
          color: black;
        "
      >
        <strong>HVIS INTERESSERT</strong>
      </div>
      <div style="margin: 0; padding: 0">
        <ul>
          <li>Tittel/tekst</li>
        </ul>
      </div>
    </div><p>&nbsp;</p>`;

    const activity_box = `    <div
      style="
        display: flex;
        flex-direction: column;
        position: relative;
        background-color: color-mix(in srgb, #f8eddd, white 15%);
        border-radius: 1rem;
        border: 2px solid black;
        padding: 2.5rem 1.25rem 1.5rem 1.25rem;
        margin: 3rem 0.25rem 0 0.25rem;
        color: black;
      "
    >
      <div
        style="
          position: absolute;
          margin: 0;
          border-radius: 9999px;
          width: 4rem;
          height: 4rem;
          max-width: 100px;
          top: -32px;
          left: 2rem;
          background-color: white;
        "
      >
        <img
          src="https://uia.instructure.com/files/2639266/download?download_frd=1&amp;verifier=RHvl9G1BZUzoqsfh636gqDrMaRiHD1puyJVoL870"
          alt=""
          role="presentation"
          loading="lazy"
          style="
            margin: 0;
            padding: 0;
            width: 4rem;
            height: 4rem;
            border-radius: 9999px;
          "
        />
      </div>
      <div
        style="
          display: flex;
          align-items: center;
          margin-bottom: 0.5rem;
          margin-top: 0;
        "
      >
        <h3 style="color: black;">
          To do
        </h3>
      </div>
      <div style="color: black;">
        <p>
          Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eu erat
          efficitur nunc viverra cursus a eu ligula. Pellentesque accumsan
          egestas dolor, pretium eleifend lectus vehicula in. Ut lacinia
          volutpat mi, non lacinia nisl placerat ac. Proin consequat et diam id
          euismod. Nam eget varius augue. Donec sodales placerat odio ut
          sagittis. Sed sed arcu enim.
        </p>
      </div>
    </div><p>&nbsp;</p>`;

    // Run
    createToolbarButton();

    // Functions
    function createToolbarButton(){
        // Create a mutation observer to catch when the editor is added to the DOM
        const observer = new MutationObserver((mutations, observer)=>{
            for(const mutation of mutations){
                const toolbars = document.querySelectorAll(".tox-toolbar__group");

                if(toolbars.length>0){
                    // Check if a button has already been added:
                    if(toolbars[toolbars.length - 1].children.namedItem("Components")){
                        observer.disconnect();
                        return;
                    }

                    // Add a new button
                    const btn = document.createElement("button");
                    btn.setAttribute("aria-label", "Components");
                    btn.setAttribute("title", "Components");
                    btn.setAttribute("name", "Components");
                    btn.setAttribute("type", "button");
                    btn.setAttribute("tabindex", "-1");
                    btn.setAttribute("class", "tox-tbtn");
                    btn.setAttribute("aria-disabled", "false");
                    btn.innerHTML = `<span class="tox-icon tox-tbtn__icon-wrap"><svg xmlns="http://www.w3.org/2000/svg" width="18px" height="18px" fill="none" viewBox="0 0 24 24" focusable="false" role="img"><path fill="currentColor" fill-rule="evenodd" d="M3.25 5A.75.75 0 0 1 4 4.25h4a.75.75 0 0 1 .75.75v.992q0 .007.002.027.003.047.021.14c.026.126.078.287.175.444.166.265.542.647 1.552.647s1.386-.382 1.552-.647a1.4 1.4 0 0 0 .198-.61V5a.75.75 0 0 1 .75-.75h4a.75.75 0 0 1 .75.75v3.547c.346-.15.788-.297 1.25-.297 1.518 0 2.75 1.448 2.75 3.25s-1.232 3.25-2.75 3.25c-.462 0-.904-.147-1.25-.297V17a.75.75 0 0 1-.75.75h-3.547c.15.346.297.788.297 1.25 0 .718-.342 1.512-.873 2.119-.544.621-1.361 1.131-2.377 1.131s-1.833-.51-2.377-1.131c-.531-.607-.873-1.401-.873-2.119 0-.462.147-.904.297-1.25H4a.75.75 0 0 1-.75-.75zm13 11.25V13.5c0-.156.037-.507.365-.736a.9.9 0 0 1 .714-.13c.135.029.26.081.347.12.09.04.189.09.277.134l.007.004c.409.204.748.358 1.04.358.482 0 1.25-.552 1.25-1.75S19.482 9.75 19 9.75c-.292 0-.631.154-1.04.358l-.008.004c-.087.044-.185.093-.276.134a1.8 1.8 0 0 1-.347.12.9.9 0 0 1-.714-.13c-.328-.23-.365-.58-.365-.736V5.75h-2.5V6H13h.75v.021a1 1 0 0 1-.008.132 2.87 2.87 0 0 1-.419 1.245c-.459.734-1.333 1.352-2.823 1.352s-2.364-.618-2.823-1.352A2.9 2.9 0 0 1 7.25 6.02v-.019S7.25 6 8 6h-.75v-.25h-2.5v10.5H8.5c.156 0 .507.037.736.365a.9.9 0 0 1 .13.714c-.029.135-.081.26-.12.347-.04.09-.09.189-.134.277l-.004.007c-.204.409-.358.748-.358 1.04 0 .282.158.738.502 1.131.331.379.764.619 1.248.619s.917-.24 1.248-.619c.344-.393.502-.849.502-1.131 0-.292-.154-.631-.358-1.04l-.004-.008c-.044-.087-.093-.185-.134-.276a1.8 1.8 0 0 1-.12-.347.9.9 0 0 1 .13-.714c.23-.328.58-.365.736-.365z" clip-rule="evenodd"></path></svg></span>`;

                    toolbars[toolbars.length - 1].appendChild(btn);

                    // Add eventlistener to the button to open a dialog to select which component to insert.
                    btn.addEventListener("click", openDialog);

                    observer.disconnect();
                }
            }
        });

        observer.observe(document.body, {subtree: true, childList: true});
    }

    function openDialog(){
        console.log("Opening");
        let componentPanel = document.createElement("dialog");
        componentPanel.style.display = "flex";
        componentPanel.style.flexDirection = "column";
        componentPanel.style.width = "clamp(300px, 100%, 800px)";
        componentPanel.innerHTML = `<h3>Select Component</h3>
        <h4>Literature box</h4>
        <div id="uia__literature_box">${literature_box}</div>
        <button style="width:fit-content; overflow: visible;" id="uia__insert_literature" class="btn Button btn-primary">Insert literature box</button>
        <hr>
        <h4>Activity box</h4>
        <div id="uia__activity_box">${activity_box}</div>
        <button style="width:fit-content; overflow: visible;" id="uia__insert_activity" class="btn Button btn-primary">Insert activity box</button>
        <hr>
        <div style="display: flex; justify-content:space-between; margin-top: 1rem;">
        <button id="uia__closeComponentPanel" class="btn Button">Close</button>
        </div>`;
        document.body.appendChild(componentPanel);
        componentPanel.showModal();

        // Handle the close-button
        let closeButton = document.getElementById("uia__closeComponentPanel");
        closeButton.addEventListener("click", ()=>{
            componentPanel.close
            document.body.removeChild(componentPanel);
        });

        // Insert buttons
        document.getElementById("uia__insert_literature").onclick = insertLiterature;
        document.getElementById("uia__insert_activity").onclick = insertActivity;
    }

    function insertLiterature(){
        console.log("Inserting literature");
        let editor = tinymce.get("wiki_page_body");
        editor.focus();
        editor.selection.setContent(literature_box);
    }

        function insertActivity(){
        console.log("Inserting activity");
        let editor = tinymce.get("wiki_page_body");
        editor.focus();
        editor.selection.setContent(activity_box);
    }
})();